// Postfix calculator

#import <stdio.h>
#import <Foundation/Foundation.h>
#import "StackOfInteger.h"

@implementation StackOfInteger;
@synthesize stackPointer=last;

- (id) init{
    self = [super init];
    self->last = -1;
    elements = [[NSMutableArray alloc] init];
    return self;
}

- (BOOL) isEmpty{
    return (self->last == -1);
}

- (void) push: (int) intValue{
    NSLog(@"Entering method >%@<", NSStringFromSelector(_cmd));
    NSNumber* intObject = [NSNumber numberWithInt:intValue];
    [elements addObject:intObject];
    self->last++;
    NSLog(@"Leaving method >%@<", NSStringFromSelector(_cmd));
}

- (void) push2: (int) intValue1 another:(int) intValue2 {
    NSNumber* intObject = [NSNumber numberWithInt:intValue1];
    [elements addObject:intObject];
    intObject = [NSNumber numberWithInt:intValue2];
    [elements addObject:intObject];
    self->last+=2;
}

- (int) pop{
    NSNumber* element = (NSNumber *) [self->elements objectAtIndex:(self->last)];
    self->last--;
    int intValue = [element intValue];
    [self->elements removeLastObject];
    return intValue;
}

/////////// Methods to implement the Printable protocol ////////////

- (void) printMe{
    int k, stackCount = [elements count];
    NSLog (@"Stack->Last >%d< \n", self->last);
    for(k=0; k<stackCount; k++) {
        NSLog (@"Element at [%d] = >%@<\n", k, [elements objectAtIndex:k]);
    }
}
/*
- (NSString *) printMeToString{
    NSString* retString;
    
    return @"printMeToString will be implemented later"; 
}
*/ 

@end

